LIBRARY IEEE;
USE IEEE.std_logic_1164.ALL;
USE IEEE.std_logic_unsigned.ALL;
PACKAGE count_types IS
  SUBTYPE bit4 IS std_logic_vector(3 DOWNTO 0);
END count_types;

LIBRARY IEEE;
USE IEEE.std_logic_1164.ALL;
USE IEEE.std_logic_unsigned.ALL;
USE WORK.count_types.ALL;
ENTITY count IS
  PORT( clock, load, clear : IN std_logic;
        din : IN bit4;
        dout : INOUT bit4);
END count;

ARCHITECTURE synth OF count IS

BEGIN
  PROCESS
  BEGIN
    IF (clear = '1') THEN
      dout <= "0000";
    ELSIF (load = '1') THEN
      dout <= din;
    ELSE
      dout <= dout + "0001";
    END IF;
    
    WAIT UNTIL clock'EVENT and clock = '1';

  END PROCESS;
END synth;

